#ifndef HEURISTICS_HPP
#define HEURISTICS_HPP

#include "basicAlgos.hpp"

/**
	Game actions structs
**/

struct GameNewState {
	VirtGameState state;
	vector<ActionHist> actions;

	void applyAction(ActionHist);
	GameNewState(VirtGameState&);
};

const int TARGET_ALIEN = 0;
const int TARGET_PROTECT = 1;
const int TARGET_ATTACK = 2;
const int TARGET_POS = 3;

struct Target {
	position pos;
	int type;
};

using target_array = array<Target, NB_AGENTS>;

/**
	Heuristics
**/

const int HEURISTIC_1 = 1;
const int HEURISTIC_2 = 2;
const int HEURISTIC_AGRO = 3;

// Base
class MoveChoice {
public:
	target_array getObjectives(int heuristic);
	position getAgentSimpleDest(int);
	MoveChoice(VirtGameState&);

	VirtGameState& state;
	double getScoreAgentToAlien(int, alien_info, int);
};

// Heuristic 1
class MoveHeuristic_1 : public MoveChoice {
public:
	target_array getObjectives(int heuristic = HEURISTIC_1);
	MoveHeuristic_1(VirtGameState&);
};

// Heuristic 2
class MoveHeuristic_2 : public MoveHeuristic_1 {
public:
	MoveHeuristic_2(VirtGameState&);
	target_array getObjectives(int heuristic = HEURISTIC_2);
};

// Heuristic 2
class MoveHeuristic_Agro : public MoveChoice {
public:
	MoveHeuristic_Agro(VirtGameState&);
	target_array getObjectives(int heuristic = HEURISTIC_AGRO);
};

#endif